/**
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies
 * or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package sample;

import sample.service.MsClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.net.URI;

@SpringBootApplication
public class Main implements CommandLineRunner {

    public static void main(String[] args) {
        SpringApplication.run(Main.class, args);
    }

    @Autowired
    MsClientService msClientService;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public void run(String... args) throws Exception {
        System.out.println("Acquiring Access Token");
        final String accessToken = msClientService.getAccessToken();
        System.out.println("Successfully retrieved Access Token");
        System.out.println();
        callMorganStanleyApi(accessToken, URI.create("https://api.morganstanley.com/hello/services"));
        System.out.println();
        System.out.println("Successfully called Morgan Stanley API. You can now close this application");
        System.out.println();
    }

    private void callMorganStanleyApi(String accessToken, URI apiEndpoint) {
        System.out.println("Calling Morgan Stanley API " + apiEndpoint.toString());
        final HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setBearerAuth(accessToken);
        final HttpEntity<String> httpEntity = new HttpEntity<>(httpHeaders);
        final ResponseEntity<String> responseEntity = restTemplate.exchange(
            apiEndpoint,
            HttpMethod.GET,
            httpEntity,
            String.class
        );
        System.out.println("Response received");
        System.out.println("Response status code: " + responseEntity.getStatusCode());
        System.out.println("Response body: " + responseEntity.getBody());
    }
}
